// 从全局对象中获取Vue和VueRouter，而不是使用import
const { createApp } = Vue;

// 导入路由配置
import router from './router.js';
// 导入TabBar组件
import TabBar from './components/tab-bar.js';

// 创建应用实例
const app = createApp({
    mounted() {
        console.log('应用已启动');
    }
});

// 注册组件和路由
app.component('tab-bar', TabBar);
app.use(router);

// 挂载应用
app.mount('#app');
    