//加载配置
import config from './config/app.js';
// 从全局对象获取VueRouter，不使用import
const { createRouter, createWebHashHistory } = VueRouter;
//const version = Date.now();
// 页面加载函数
async function loadPage(pageName) {
    try {

        //debug模式下，避免css、js缓存
        if(config.debug){
            var random = Date.now();
        }else{
            var random = config.version;
        }
        
        //CSS链接代码
        const css = `<link rel="stylesheet" href="pages/${pageName}/${pageName}.css?v=${random}">`;

        // 加载HTML模板
        const htmlResponse = await fetch(`pages/${pageName}/${pageName}.html`);
        const html = await htmlResponse.text();
        
        // 加载CSS(此方式会导至css冲突)
        // const link = document.createElement('link');
        // link.rel = 'stylesheet';
        // link.href = `pages/${pageName}/${pageName}.css?v=${version}`;
        // document.head.appendChild(link);

        // 加载JS模块
        const module = await import(`./pages/${pageName}/${pageName}.js?v=${random}`);
        
        //模版代码=css+js
        const template = css + html;
        return {
            template: template,
            ...module.default
        };
    } catch (error) {
        console.error(`加载页面${pageName}失败:`, error);
        return {
            template: `<div class="error-page">页面加载失败</div>`
        };
    }
}

// 路由配置
const routes = [
    { path: '/', redirect: '/home' },
    { path: '/home', component: () => loadPage('home') },
    { path: '/message', component: () => loadPage('message') },
    { path: '/contact', component: () => loadPage('contact') },
    { path: '/mine', component: () => loadPage('mine') },
    { path: '/:pathMatch(.*)*', component: { template: '<div>404 页面未找到</div>' } }
];

// 创建路由实例
const router = createRouter({
    history: createWebHashHistory(),
    routes
});

// 导出路由实例（使用全局变量方式，避免模块导出问题）
window.appRouter = router;
export default router;
    